(function(w, d, s) {
    var fledgePageUrl = s + '/s/fledge/MSFledgePage.html';
    var fledgePageUETParameter = 'UETEventStr';

    var isEdgeBrowser = /Edg/.test(navigator.userAgent);
    var isOpera = /OPR/.test(navigator.userAgent);
    var isChromeBrowser = /Chrome/.test(navigator.userAgent) && /Google Inc/.test(navigator.vendor) && !isEdgeBrowser && !isOpera;

    if (!isEdgeBrowser && !isChromeBrowser) {
        return;
    }

    if (typeof window.CustomEvent !== 'function')
        return;

    d.addEventListener("UetEvent", function(event) {
        var UETParams = getFledgeParams([event.detail.uetEvent]);
        if (UETParams.size > 0) loadIframe(UETParams, fledgePageUrl);
    });

    var rndObjName = d.currentScript.getAttribute('data-ueto');
    if (!rndObjName) return;

    var uetInstance = w[rndObjName];
    if (!uetInstance) return;

    var fledgeParams = getFledgeParams(uetInstance.snippetEventQueue);
    if (fledgeParams.size > 0) loadIframe(fledgeParams, fledgePageUrl);

    function getFledgeParams(eventQueue) {
        let params = new URLSearchParams();
        eventQueue
            .filter(function(evtStr) {
                var kvps = new URLSearchParams(evtStr);
                if (!kvps.get('cdl')) return false;
                if (!kvps.get('cdl').includes('control_2') && !kvps.get('cdl').includes('treatment') && isChromeBrowser) return false;
                if (!kvps.get('cdl').includes('treatment_1.1') && isEdgeBrowser) return false;
                if (kvps.has('gdpr', 'Y') && kvps.has('tcf', 'st=L') && kvps.has('as', 'D')) return false;
                if (kvps.has('asc', 'D')) return false;
                return kvps.get('evt') !== 'custom';
            })
            .forEach((uetEventStr) => {
                params.append(fledgePageUETParameter, encodeURIComponent(uetEventStr));
            });
        return params;
    }

    function loadIframe(params, fledgePageUrl) {
        var fledgeIframe = document.createElement('iframe');
        fledgeIframe.style.display = "none";
        fledgeIframe.id = 'FledgeIFrame' + makeRandomStr(10);
        document.body.appendChild(fledgeIframe);

        fledgeIframe.src = fledgePageUrl + '?' + params.toString();
    }

    function makeRandomStr(length) {
        var str = '';
        for (var i = 0; i < Math.ceil(length / 2); i++)
            str += _SB(Math.floor(Math.random() * 256));
        return str.slice(-length);
    };

    function _SB(n) {
        // indexEnd is insurance to make sure no more than 2 chars
        return (n + 0x100).toString(16).substring(1, 3);
    };
})(window, document, "https://bat.bing.com");
(function(w, d, c, k, a, b, t, e) {
    var cs = d.currentScript;
    if (cs) {
        var uo = cs.getAttribute('data-ueto');
        if (uo && w[uo] && typeof w[uo].setUserSignals === 'function') {
            w[uo].setUserSignals({
                'ea': c,
                'kc': k,
                'at': a,
                'bi': b,
                'dt': t,
                'ec': e
            });
        }
    }
})(window, document, false, false, false, false, true, false);
(function(w, d, s, i) {
    var c = d.currentScript;
    if (c) {
        var uo = c.getAttribute('data-ueto');
        if (uo && w[uo] && w[uo].uetConfig && w[uo].uetConfig.deBlock === true)
            return;
    }
    var f, j;
    f = d.getElementsByTagName(s)[0];
    j = d.createElement(s);
    j.async = true;
    j.src = 'https://bat.bing.com/p/insights/t/' + i;
    j.onload = function() {
        if (!c) return;
        var co = function(u) {
            return u && typeof u === 'object' && !(u instanceof Array) && u.beaconParams && u.beaconParams.mid && w.webinsights;
        };
        var r = 40;
        var cl = function() {
            if (r-- < 1) return;
            var uo = c.getAttribute('data-ueto');
            if (!uo) return;
            var u = w[uo];
            w.insightsuetq = w.mtagq || u;
            if (!co(u)) {
                setTimeout(function() {
                    cl();
                }, 250);
                return;
            }
            var m = u.beaconParams.mid;
            w.webinsights('set', '_uetmid', m);
            w.webinsights('metadata', (function() {
                w.webinsights('set', '_uetmid', m);
            }), false);
            d.addEventListener('UetEvent', function(e) {
                var nm = u.beaconParams.mid;
                if (m !== nm) {
                    m = nm;
                    w.webinsights('set', '_uetmid', m);
                }
            });
        };
        cl();
    };
    f.parentNode.insertBefore(j, f);
})(window, document, 'script', '4000034');