import { IWebAuthProviderConfigBase } from '@mecontrol/public-api';
import {
    IAuthNavigationProvider,
    ISignInArgs,
    ISignInToArgs,
    ISignOutFromAppArgs,
    ISignOutFromIdpArgs,
    ISwitchArgs,
    ISwitchToArgs,
    ISignOutAndForgetFromIdpArgs
} from '@mecontrol/common';
import { isString } from '../../../utilities';
import {
    createSignInRequest,
    createSignInToRequest,
    createSignOutRequest,
    createSwitchToRequest,
    createSwitchRequest
} from './urlHelpers';

export class WebAuthNavProvider implements IAuthNavigationProvider {
    constructor(private config: IWebAuthProviderConfigBase) {}

    public getSignInUrl(args: ISignInArgs): string | undefined {
        return isString(this.config.appSignInUrl)
            ? createSignInRequest(this.config.appSignInUrl, args)
            : this.config.appSignInUrl();
    }

    public getSignInToUrl(args: ISignInToArgs): string | undefined {
        return isString(this.config.appSignInToUrl)
            ? createSignInToRequest(this.config.appSignInToUrl, args)
            : this.config.appSignInToUrl(args);
    }

    public getSignOutFromAppUrl(args: ISignOutFromAppArgs): string | undefined {
        return isString(this.config.appSignOutUrl)
            ? createSignOutRequest(this.config.appSignOutUrl, args)
            : this.config.appSignOutUrl(args);
    }

    public getSignOutFromIdpUrl(args: ISignOutFromIdpArgs): string | undefined {
        return;
    }

    public getSignOutAndForgetFromIdpUrl(
        args: ISignOutAndForgetFromIdpArgs
    ): string | undefined {
        // Don't return the this.config.msa(or aad).signOutAndForgetUrl here.
        // The Urls in this provider are intended to redirect the current
        // webpage. signOutandForgetUrl is suppose to be opened in an Iframe.
        return;
    }

    public getSwitchUrl(args: ISwitchArgs): string | undefined {
        return isString(this.config.appSwitchUrl)
            ? createSwitchRequest(this.config.appSwitchUrl, args)
            : this.config.appSwitchUrl(args);
    }

    public getSwitchToUrl(args: ISwitchToArgs): string | undefined {
        return isString(this.config.appSwitchToUrl)
            ? createSwitchToRequest(this.config.appSwitchToUrl, args)
            : this.config.appSwitchToUrl(args);
    }
}
