import { AccountType } from '@mecontrol/public-api';
import { IAuthProvider } from '@mecontrol/common';

export function canLeverageRememberedAccounts(authProvider: IAuthProvider, accountType: AccountType): boolean {
    return authProvider.isOperationSupported('switchTo', accountType) ||
        authProvider.isOperationSupported('signInTo', accountType);
}

export function isRememberedAccountsSupported(authProvider: IAuthProvider): boolean {
    const op = 'getRememberedAccounts';
    return authProvider.isOperationSupported(op, AccountType.MSA) ||
        authProvider.isOperationSupported(op, AccountType.MSA_FED) ||
        authProvider.isOperationSupported(op, AccountType.AAD);
}
