import {
    ISignInArgs,
    ISignInToArgs,
    ISwitchArgs,
    ISwitchToArgs,
    ISignOutFromAppArgs,
    ISignOutAndForgetFromIdpArgs,
    ISignOutFromIdpArgs
} from '@mecontrol/common';
import { getPageLocation } from '@mecontrol/web-inline';
import { setQueryParams, hasQueryParam } from '../../../utilities';

const loginHintKey = "login_hint";
const returnUrlKey = "ru";
const sessionIdKey = "sessionId";

function updateQueryParams(url: string, loginHint?: string, sessionId?: string): string {
    let params: Record<string, string> = {};

    if (!hasQueryParam(url, 'ru')) {
        params[returnUrlKey] = getPageLocation().href;
    }

    if (loginHint) {
        params[loginHintKey] = loginHint;
    }

    if (sessionId) {
        params[sessionIdKey] = sessionId;
    }

    return setQueryParams(url, params);
}

export function createSignInRequest(url: string, args: ISignInArgs): string {
    return updateQueryParams(url);
}

export function createSignInToRequest(url: string, args: ISignInToArgs): string {
    return updateQueryParams(url, args.nextAccount.memberName);
}

export function createSwitchRequest(url: string, args: ISwitchArgs): string {
    return updateQueryParams(url);
}

export function createSwitchToRequest(url: string, args: ISwitchToArgs): string {
    return updateQueryParams(url, args.nextAccount.memberName);
}

export function createSignOutRequest(url: string, args: ISignOutFromAppArgs): string {
    return updateQueryParams(url, undefined, args.currentAccount.sessionId);
}

export function createSignOutFromIdpRequest(url: string, args: ISignOutFromIdpArgs): string {
    return setQueryParams(url, {
        [sessionIdKey]: args.account.sessionId,
        shouldForgetUser: 'false',
        isIframe: 'true',
    });
}

export function createSignOutAndForgetRequest(url: string, args: ISignOutAndForgetFromIdpArgs): string {
    return setQueryParams(url, {
        [sessionIdKey]: args.account.sessionId,
        shouldForgetUser: 'true',
        isIframe: 'true',
    });
}

export function createForgetRequest(url: string, args: ISignOutAndForgetFromIdpArgs): string {
    return setQueryParams(url, {
        [sessionIdKey]: args.account.sessionId
    });
}
