import { h, FunctionalComponent } from 'preact';
import { AnchorPosition, PageAction } from '@mecontrol/common';
import { IMenuItemProps, Menu } from '../Menu';

export interface IAccountActionsProps {
    id: string;
    index: number;
    items: IMenuItemProps[];
    triggerAriaLabel: string;
}

export const AccountActions: FunctionalComponent<IAccountActionsProps> = props => (
    <Menu
        id={props.id}
        contentId={PageAction.accountActions}
        contentSlot={props.index}
        trigger={{
            children: [<div class='mectrl_glyph glyph_more' />],
            cssClass: 'mectrl_trigger',
            ariaLabel: props.triggerAriaLabel,
            tooltip: true
        }}
        items={props.items}
        cssClass='mectrl_accountActions'
        position={AnchorPosition.Left}
    />
);
