import { h, FunctionalComponent } from 'preact';
import cc from 'classcat';
import { createId } from '@mecontrol/web-inline';
import { TruncateText } from '@mecontrol/web-boot';

export interface IAccountInfoProps {
    id: string;
    friendlyName: string;
    details?: string;
    isHighlighted?: boolean;
}

export const AccountInfo: FunctionalComponent<IAccountInfoProps> = props => {
    const { id, friendlyName, details, isHighlighted = false } = props;

    // Format account info to display correctly
    return (
        <div class='mectrl_accountItemInfo'>
            <TruncateText id={createId(id, 'primary')} text={friendlyName} cssClass={cc({ signedIn: isHighlighted })} />
            {
                // Check to see if we even need to render details
                details && friendlyName != details ?
                    <TruncateText id={createId(id, 'secondary')} text={details} /> :
                    null
            }
        </div>
    );
};
