import { h, RenderableProps } from "preact";
import { toChildArray } from "@mecontrol/web-boot";

interface ScrollShadowProps {
    cssClass: string;
}

/**
 * Add a shadow to the the top of an element that is scrolled. The usage of this
 * component must provide a CSS class through which it controls the scrolling behavior
 * of the div element (e.g. using overflow: auto, max-height, etc.).
 */
export function ScrollShadow(props: RenderableProps<ScrollShadowProps>): JSX.Element {
    return (
        <div class={"mectrl_scrollShadow " + props.cssClass}>
            {toChildArray(props.children)[0]}
        </div>
    );
}
