import { h, FunctionalComponent } from 'preact';
import { getString, createId } from '@mecontrol/web-inline';

/**
 * Simple JSX component that redners a subtle text header for the account list when
 * the user is not actively signed in.
 */
export const SignedOutAccountListHeader: FunctionalComponent = () => {
    return (
        <h1 id={createId('signInTitle')} class='mectrl_signedOutAccountListHeader'>
            {getString('chooseanaccount')}
        </h1>
    );
};
