import { Reducer } from 'redux';
import { AllActions, ActionTypes } from '@mecontrol/common';
import { getAccountId } from '../../utilities/accounts';

/**
 * Reducer function to handle the string from the accounts state that stores the active account's ID (if any)
 * @param state Current active account's ID (or empty string for no active accounts)
 * @param action Dispatched action to change the state
 * @returns The new state given the action
 */
export const currentId: Reducer<string> = (state = '', action: AllActions) => {
    switch (action.type) {
        // When initializing options, we only set the string if the options
        // include an active account
        case ActionTypes.INIT_OPTIONS:
            if (action.payload.options.currentAccount) {
                return getAccountId(action.payload.options.currentAccount);
            }

            return '';

        // When setting an active account, we just replace the current value
        // with the new one's ID
        case ActionTypes.SET_ACTIVE_ACCOUNT:
            return getAccountId(action.payload.account);

        // Remove the active account
        case ActionTypes.REMOVE_ACTIVE_ACCOUNT:
            return '';

        default:
            return state;
    }
};
