import { Reducer } from 'redux';
import { AllActions, ActionTypes } from '@mecontrol/common';

export const breakpoint: Reducer<number> = (state = -1, action: AllActions) => {
    switch (action.type) {
        case ActionTypes.INIT_OPTIONS:
            // Get first valid displayMode or return a negative number
            const displayModes = action.payload.options.primaryUXConfig.displayModes;
            if (displayModes.length > 0) {
                return displayModes[0].widthBreakpoint;
            }
            else {
                return -1;
            }
        default:
            return state;
    }
};
