import { PresenceActions, ActionTypes, MeControlThunkAction, UpdatePresenceConfig, UpdatePresenceState } from '@mecontrol/common';
import { IPresenceState, IPresenceConfig, OnErrorDetail } from '@mecontrol/public-api';
import { SyntheticEvent } from '@mecontrol/web-inline';

export function setPresenceConfig(presenceConfig: IPresenceConfig): UpdatePresenceConfig {
    return {
        type: ActionTypes.UPDATE_PRESENCE_CONFIG,
        payload: {
            presenceConfig
        }
    };
}

export function setPresence(presenceState: IPresenceState): UpdatePresenceState {
    return {
        type: ActionTypes.UPDATE_PRESENCE_STATE,
        payload: {
            currentPresence: presenceState
        }
    };
}

export function setPresenceToPartner(presenceState: IPresenceState): MeControlThunkAction<PresenceActions> {
    return (dispatch, getState, { syntheticEventTarget }) => {
        try {
            dispatch({
                type: ActionTypes.UPDATE_PRESENCE_STATE_TO_PARTNER_SUCCESS,
                payload: {
                    currentPresence: presenceState
                }
            });
            syntheticEventTarget.dispatchEvent(new SyntheticEvent("presenceupdated", presenceState));
        } catch (e) {
            dispatch({
                type: ActionTypes.UPDATE_PRESENCE_STATE_TO_PARTNER_FAIL,
            });
            const detail: OnErrorDetail = { type: "PresenceError", error: e, data: presenceState };
            syntheticEventTarget.dispatchEvent(new SyntheticEvent("error", detail));
        }
    };
}
