import { IAccount, RuntimeDisplayMode, ITheme, ICommand } from '@meControl/public-api';
import {
    ActionTypes,
    SetActiveAccountAction,
    SetDisplayModeAction,
    SetThemeAction,
    SetCommandsAction,
    SetProfilePictureAction,
    SetAccountPictureAction,
    RemoveActiveAccountAction,
    SetHeaderThemeAction,
    RefreshPictureAction,
} from '@mecontrol/common';

/**
 * Replace the currently active account in the control
 * @param account Account to set as active
 */
export function setActiveAccount(account: IAccount): SetActiveAccountAction {
    return {
        type: ActionTypes.SET_ACTIVE_ACCOUNT,
        payload: {
            account
        }
    };
}

/**
 * Remove the currently active account from state
 * @param accountId Id of the currently active account
 */
export function removeActiveAccount(accountId: string): RemoveActiveAccountAction {
    return {
        type: ActionTypes.REMOVE_ACTIVE_ACCOUNT,
        payload: {
            accountId
        }
    };
}

/**
 * Sets the display mode of the control
 * @param mode Display mode to be configured
 */
export function setDisplayMode(mode: RuntimeDisplayMode): SetDisplayModeAction {
    return {
        type: ActionTypes.SET_DISPLAY_MODE,
        payload: {
            mode
        }
    };
}

/**
 * Sets the theme of the control
 * @param theme Dark or Light theme
 */
export function setTheme(theme: ITheme): SetThemeAction {
    return {
        type: ActionTypes.SET_THEME,
        payload: {
            theme
        }
    };
}

/**
 * Sets the theme of the control
 * @param headerTheme Dark or Light theme for the MeControl header
 */
export function setHeaderTheme(headerTheme: ITheme): SetHeaderThemeAction {
    return {
        type: ActionTypes.SET_HEADER_THEME,
        payload: {
            headerTheme
        }
    };
}

export function setCommands(commands: ICommand[]): SetCommandsAction {
    return {
        type: ActionTypes.SET_COMMANDS,
        payload: {
            commands
        }
    };
}

export function setProfilePicture(newUrl: string, accountId: string): SetProfilePictureAction {
    return {
        type: ActionTypes.SET_PROFILE_PICTURE,
        payload: {
            newUrl,
            accountId
        }
    };
}

export function setAccountPicture(newUrl: string, accountId: string): SetAccountPictureAction {
    return {
        type: ActionTypes.SET_ACCOUNT_PICTURE,
        payload: {
            newUrl,
            accountId
        }
    };
}

export function refreshPicture(url: string, apiName: string): RefreshPictureAction {
    return {
        type: ActionTypes.REFRESH_PICTURE,
        payload: {
            url
        },
        meta: {
            apiName
        }
    };
}
