import { h, FunctionalComponent } from "preact";
import { IMeControlAccounts, IAuthProvider, IAuthActions } from '@mecontrol/common';
import { getCurrentAccount } from '@mecontrol/web-boot';
import { CurrentAccount } from './CurrentAccount';
import { AccountList } from './account-list/AccountList';
import { ICommand, ITheme } from '@mecontrol/public-api';
import { SignedOutAccountListHeader } from './account-list/SignedOutAccountListHeader';

export interface IBodyOwnProps {
    authProvider: IAuthProvider;
}

export interface IBodyStateProps {
    accounts: IMeControlAccounts;
    commands?: ICommand[];
    theme?: ITheme;
}

export interface IBodyDispatchProps extends IAuthActions {
}

export type IBodyProps = IBodyStateProps & IBodyDispatchProps & IBodyOwnProps;

export const Body: FunctionalComponent<IBodyProps> = props => {
    const {
        accounts,
        commands,
        authProvider,
        signOutFromApp,
    } = props;

    const currentAccount = getCurrentAccount(accounts);
    const children: JSX.Element[] = [];

    if (currentAccount) {
        // Signed in w/ Active Account
        children.push(
            <CurrentAccount
                currentAccount={currentAccount}
                commands={commands}
                authProvider={authProvider}
                signOutFromApp={signOutFromApp}
            />,
            <AccountList {...props} />
        );
    }
    else {
        // Else signed out, push the header and remembered accounts.
        children.push(
            <SignedOutAccountListHeader />,
            <AccountList {...props} />
        );
    }

    return <div class="mectrl_body">{children}</div>;
};
