import { FunctionalComponent, h } from 'preact';
import { IAccountState } from '@mecontrol/common';
import { getString, createId } from '@mecontrol/web-inline';
import { TruncateText, isFunctionallyMsaLike } from '@mecontrol/web-boot';

export interface ICompanyProps {
    account: IAccountState;
}

/**
 * Used to display company information in the flyout header. When the passed in account
 * is MSA-like, then the Microsoft logo and name are displayed. For AAD accounts, the name
 * of the organization is used (when available)
 * @param account Account for which the companny information will be generated
 */
export const Company: FunctionalComponent<ICompanyProps> = ({ account }) => {
    const id = createId('signedInTitle');
    const companyClass = 'mectrl_company';

    // MSA-like shows Microsoft branding
    if (isFunctionallyMsaLike(account)) {
        return (
            <div class={companyClass}>
                <div class='mectrl_glyph glyph_msft' style={{width: '80px'}} aria-label="logo">
                    <div class='glyph_text'>
                        {getString('microsoft')}
                    </div>
                </div>
            </div>
        );
    }
    else {
        // TODO: Ignore orgLogoUrl for now and put AAD briefcase here instead   \
        // {props.orgLogoUrl ? <img src={props.orgLogoUrl} /> : <ListDropdownTrigger glyphClass='glyph_more' ariaLabel={getString('morecustomlinks')} />}
        return account.orgName ? <TruncateText id={id} cssClass={companyClass} text={account.orgName} /> : null;
    }
};
