import { h, FunctionalComponent, ComponentFactory } from 'preact';
import { IPresenceState } from '@mecontrol/public-api';
import { IAccountState, IMeControlAppState } from '@mecontrol/common';
import { isFunctionallyMsaOrWithEditPicUrl, ProfilePictureOverlay, ProfilePicture, MapStateToProps, connect } from '@mecontrol/web-boot';

export interface IPresenceOwnProps {
    mainIdPart?: string;
    currentAccount: IAccountState;
    pictureId?: string;
}

export interface IPresenceStateProps {
    currentPresence?: IPresenceState;
}

export type IPresenceProps = IPresenceOwnProps & IPresenceStateProps;

const PresenceImpl: FunctionalComponent<IPresenceProps> = props => {
    let { currentAccount, currentPresence } = props;
    let imgCss: { [backgroundImage: string]: string } = {};

    let presenceElement = isFunctionallyMsaOrWithEditPicUrl(currentAccount) && props.pictureId ?
        <ProfilePictureOverlay id={props.pictureId} {...props} /> :
        <div id={props.pictureId}>
            <ProfilePicture {...props}/>
        </div>;

    if (props.mainIdPart && currentPresence) {
        imgCss.backgroundImage = 'url(' + currentPresence.imageUrl + ')';
        presenceElement = <div class="mectrl_presence_container">
            <div class={"mectrl_presence"} style={imgCss}></div>
            {presenceElement}
        </div>;
    }

    return (presenceElement);
};

const mapStateToProps: MapStateToProps<IMeControlAppState, IPresenceStateProps> = state => ({
    currentPresence: state.presenceConfig.currentPresence
});

export const Presence: ComponentFactory<IPresenceOwnProps> = connect(mapStateToProps, () => { return; })(PresenceImpl);
