import { h, FunctionalComponent } from "preact";
import { Promise } from '@mecontrol/web-inline';
import { IPresenceHeaderProps } from '@mecontrol/web-core';
import { RenderAsync } from '../core/RenderAsync';
import { loadCore } from '../utilities';

function loadCoreBody(): Promise<FunctionalComponent<IPresenceHeaderProps>> {
    return loadCore().then(meCore => meCore.PresenceHeader) as Promise<FunctionalComponent<IPresenceHeaderProps>>;
}

/**
 * The PresenceAync component allows the PresenceHeader component to be loaded at
 * a later time. This reduces the size of web-boot by moving all relevant rendering logic
 * into web-core.
 */
export const PresenceAsync: FunctionalComponent<IPresenceHeaderProps> = props => {
    // When loading or facing an error, we simply display nothing
    const loadingOrError = () => null as any;
    return (
        <RenderAsync
            loader={loadCoreBody}
            render={(PresenceHeader: any) => <PresenceHeader />}
            renderLoading={loadingOrError}
            renderError={loadingOrError}
        />
    );
};
