import { FunctionalComponent, h, ComponentFactory } from 'preact';
import { IPresenceState } from '@mecontrol/public-api';
import { IMeControlAppState } from '@mecontrol/common';
import { MapStateToProps, connect } from '@mecontrol/web-boot';

export interface IPresenceHeaderStateProps {
    currentPresence?: IPresenceState;
}

export type IPresenceHeaderProps = IPresenceHeaderStateProps;

const PresenceHeaderImpl: FunctionalComponent<IPresenceHeaderProps> = props => {
    let { currentPresence } = props;
    let imgCss: { [backgroundImage: string]: string } = {};
    let presenceHeader = null;
    if (currentPresence) {
        imgCss.backgroundImage = 'url(' + currentPresence.imageUrl + ')';
        presenceHeader = <div class='mectrl_presence_header' style={imgCss}></div>;
    }

    return (presenceHeader);
};

const mapStateToProps: MapStateToProps<IMeControlAppState, IPresenceHeaderStateProps> = state => ({
    currentPresence: state.presenceConfig.currentPresence
});

export const PresenceHeader: ComponentFactory<{}> = connect(mapStateToProps, () => { return; })(PresenceHeaderImpl);
