import { h, FunctionalComponent } from 'preact';
import { TruncateTag } from './TruncateTag';

export interface ITruncateTextProps {
    text: string;
    id?: string;
    cssClass?: string;
    ariaLabel?: string;
    hideTooltip?: boolean;
    [key: string]: any;
}

export const TruncateText: FunctionalComponent<ITruncateTextProps> = props => {
    const { text, id, cssClass, ariaLabel, hideTooltip, ...otherAttributes } = props;

    return (
        <TruncateTag
            tag='div'
            title={text}
            id={id}
            class={cssClass}
            aria-label={ariaLabel}
            hideTooltip={hideTooltip}
            {...otherAttributes}
        >
            {text}
        </TruncateTag>
    );
};
