import { Component, RenderableProps } from "preact";
import { Store } from "redux";
import { toChildArray } from './toChildArray';

// TODO: Consider the following file which has a smaller Provider implementation
// https://github.com/developit/unistore/blob/7b1d868b977c1730e277dd74de61867272cc2706/src/integrations/preact.js

export interface ProviderContext<S> {
    store: Store<S>;
}

export interface ProviderProps<S> {
    store: Store<S>;
}

/**
 * Provider exposes a store (passed as `props.store`) into context.
 * Generally, an entire application is wrapped in a single `<Provider>` at the root.
 */
export class Provider<State> extends Component<ProviderProps<State>, never> {
    private store: Store<State>;

    constructor(props: ProviderProps<State>) {
        super(props);
        this.store = props.store;
    }

    public getChildContext(): ProviderContext<State> {
        return {
            store: this.store
        };
    }

    public render(props: RenderableProps<ProviderProps<State>>): JSX.Element | null {
        if (props.children) {
            return toChildArray(props.children)[0];
        }

        return null;
    }
}
