import { Reducer } from 'redux';
import { ICommand } from '@mecontrol/public-api';
import { AllActions, ActionTypes } from '@mecontrol/common';

export const commands: Reducer<ICommand[]> = (state = [], action: AllActions) => {
    switch (action.type) {
        case ActionTypes.INIT_OPTIONS:
            return (action.payload.options.appContextConfig && action.payload.options.appContextConfig.commands) || [];
        case ActionTypes.SET_COMMANDS:
            return action.payload.commands;
        default:
            return state;
    }
};
