import { Reducer } from 'redux';
import { AllActions, ActionTypes } from '@mecontrol/common';
import { ITheme } from '@mecontrol/public-api';

export const headerTheme: Reducer<ITheme> = (state = {type: "light"} as ITheme, action: AllActions) => {
    let newState = state;
    if (action.type == ActionTypes.INIT_OPTIONS && action.payload.options.primaryUXConfig && action.payload.options.primaryUXConfig.headerTheme) {
        newState = action.payload.options.primaryUXConfig.headerTheme;
    }
    if (action.type == ActionTypes.SET_HEADER_THEME && action.payload.headerTheme.type !== state.type) {
        newState = action.payload.headerTheme;
    }

    return newState;
};
