import { Reducer } from 'redux';
import { IPresenceConfig } from '@mecontrol/public-api';
import { AllActions, ActionTypes } from '@mecontrol/common';

export const presenceConfig: Reducer<IPresenceConfig> = (state = {}, action: AllActions) => {
    if (action.type == ActionTypes.INIT_OPTIONS && action.payload.options.presenceConfig) {
        return action.payload.options.presenceConfig;
    }
    if (action.type == ActionTypes.UPDATE_PRESENCE_CONFIG) {
        return action.payload.presenceConfig;
    }
    if (action.type == ActionTypes.UPDATE_PRESENCE_STATE || action.type == ActionTypes.UPDATE_PRESENCE_STATE_TO_PARTNER_SUCCESS) {
        const newState = {
            ...state,
        };
        newState.currentPresence = action.payload.currentPresence;
        return newState;
    }
    return state;
};
