import { Reducer } from 'redux';
import { AllActions, ActionTypes } from '@mecontrol/common';
import { ITheme } from '@mecontrol/public-api';

export const theme: Reducer<ITheme> = (state = {type: "light"} as ITheme, action: AllActions) => {
    let newState = state;
    if (action.type == ActionTypes.INIT_OPTIONS && action.payload.options.primaryUXConfig && action.payload.options.primaryUXConfig.theme) {
        newState = action.payload.options.primaryUXConfig.theme;
    }
    if (action.type == ActionTypes.SET_THEME && action.payload.theme.type !== state.type) {
        newState = action.payload.theme;
    }

    return newState;
};
