import { createStore, compose, applyMiddleware } from 'redux';
import thunk, { ThunkMiddleware } from 'redux-thunk';
import { IMeControlAppState, IReduxThunkExtraArg, AllActions, MeControlStore } from '@mecontrol/common';
import { rootReducer } from '../reducers';
import { errorHandler } from './errorHandling';
import { telemetryLayer } from './telemetryLayer';

declare global {
    interface Window {
        __REDUX_DEVTOOLS_EXTENSION_COMPOSE__?: (options: any) => typeof compose;
    }
}

export function configureStore(reduxThunkExtraArg: IReduxThunkExtraArg): MeControlStore {
    const extensionCompose = window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__;
    const composeEnhancers = (extensionCompose && extensionCompose({ serialize: true })) || compose;

    return createStore(
        rootReducer,
        composeEnhancers(applyMiddleware(
            thunk.withExtraArgument(reduxThunkExtraArg) as ThunkMiddleware<IMeControlAppState, AllActions, IReduxThunkExtraArg>,
            errorHandler,
            telemetryLayer
        ))
    );
}
