import { Middleware } from 'redux';
import { IMeControlAppState } from '@mecontrol/common';
import { updateMoment } from '@mecontrol/web-inline';
import { getCurrentAccountType } from '../utilities';

/**
 * Middleware meant to be used for telemetry purposes related to our
 * redux state and action
 * @param store Store instance used in the middleware
 * @param next The middleware-enhanced version of dispatch that this middleware
 * will wrap around. This is what should be called to actually dispatch the passed-in action
 * @param action Redux action to be dispatched
 */
export const telemetryLayer: Middleware = store => next => action => {
    // Telemetry-related logic to run before an action changes the state goes here
    // doTelemetryStuff();

    // Let the action do its thing
    let result = next(action);

    // Telemetry-related logic after the state has been changed from the action
    const newState: IMeControlAppState = store.getState();
    const currentAccountType = getCurrentAccountType(newState);
    const totalAccounts = newState.accounts.allIds.length;
    updateMoment(currentAccountType, totalAccounts);

    // Return action's result
    return result;
};
