import {
    setEventCreator
} from '@mecontrol/web-inline';


import { createContentUpdate } from './creators/contentUpdate';
import { createPageAction } from './creators/pageAction';
import { createPartnerApiCall } from './creators/partnerApiCall';

/**
 * Set up additional event creators and writers
 */
export function enhanceTelemetry(): void {

    setEventCreator('ContentUpdate', createContentUpdate);
    setEventCreator('PageAction', createPageAction);
    setEventCreator('PartnerApiCall', createPartnerApiCall);
}
