/** ID of the element that will be the live region for the announcer */
const announcerId = 'mectrl_announcer';

/**
 * Read a given message out-loud for non-sighted users.
 * @param message Message to announce out loud
 */
export function announce(message: string): void {
    let announcerElement = document.getElementById(announcerId) as HTMLDivElement || createAnnouncer();
    announcerElement.textContent = '';
    announcerElement.textContent = message;
}

/**
 * Create the HTML Element that will be the live region for status updates
 */
function createAnnouncer(): HTMLDivElement {
    // Create announcer element
    let elem = document.createElement('div');
    elem.setAttribute('id', announcerId);
    elem.setAttribute('aria-live', 'polite');
    elem.setAttribute('aria-atomic', 'true');
    elem.setAttribute('role', 'status');
    elem.setAttribute('style', 'width: 0px; height: 0px; position: absolute; overflow: hidden;');

    // Append it to the document
    document.body.appendChild(elem);
    return elem;
}
