/**
 * Gets cookie by name.
 * @param name {string} Cookie name.
 * @returns Cookie value or null, if cookie was not found.
 */
export function getCookie(name: string): string | null {
    //  See: https://developer.mozilla.org/en-US/docs/Web/API/document/cookie
    return decodeURIComponent(
        document.cookie.replace(
            new RegExp(
                '(?:(?:^|.*;)\\s*' +
                encodeURIComponent(name).replace(/[\-\.\+\*]/g, '\\$&') +
                '\\s*\\=\\s*([^;]*).*$)|^.*$'
            ), '$1'
        )
    ) || null;
}
