export function find<T>(array: T[], predicate: (value: T, index: number, array: T[]) => boolean): T | undefined {
    // 1. Let O be ? ToObject(array value).
    if (array == null) {
        throw TypeError('"array" is null or not defined');
    }

    const o = Object(array);

    // 2. Let len be ? ToLength(? Get(O, "length")).
    const len = o.length >>> 0;

    if (typeof predicate !== 'function') {
        throw TypeError('predicate must be a function');
    }

    // 4. If thisArg was supplied, let T be thisArg; else let T be undefined.
    const thisArg = arguments[2];

    // 5. Let k be 0.
    let k = 0;

    // 6. Repeat, while k < len
    while (k < len) {
        // a. Let Pk be ! ToString(k).
        // b. Let kValue be ? Get(O, Pk).
        // c. Let testResult be ToBoolean(? Call(predicate, T, « kValue, k, O »)).
        // d. If testResult is true, return kValue.
        const kValue = o[k];
        if (predicate.call(thisArg, kValue, k, o)) {
            return kValue;
        }
        // e. Increase k by 1.
        k++;
    }

    // 7. Return undefined.
    return undefined;
}
