/**
 * Utility function to return a partial object, containing a subset of the properties an original
 * one had
 * @param original Original Object from which to generate the new partial object
 * @param keys Array of property names that we want the returned object to have
 */
export function pick<T, K extends keyof T>(original: T, keys: K[]): Pick<T, K> {
    let newObject: any = {};
    for (let k of keys) {
        newObject[k] = original[k];
    }
    return newObject;
}
