import {
    IValidatedMeControlConfiguration,
    MeControlEventType,
    EventDetailsMap,
} from '@mecontrol/common';
import { getOptions, SyntheticEvent } from '@mecontrol/web-inline';

export function raiseSyntheticEvent<Type extends MeControlEventType>(
    type: Type,
    details: EventDetailsMap[Type],
    browserEvent: Event
): void {
    let meControlOptions:
        | IValidatedMeControlConfiguration
        | undefined = getOptions();
    if (meControlOptions) {
        const syntheticEvent = new SyntheticEvent(type, details);
        const defaultPrevented = !meControlOptions.syntheticEventTarget.dispatchEvent(
            syntheticEvent
        );
        if (defaultPrevented) {
            browserEvent.preventDefault();
            return;
        }
    }
    // TODO: send telemetry on failed getOptions() calls
}
