import { ITheme, ThemeType } from '@mecontrol/public-api';
import { assertNever } from '@mecontrol/web-inline';

export function getThemeClass(theme: ITheme, isHeader?: boolean): string {
    const headerClass = `${isHeader ? `_header` : ``}`;
    switch (theme.type) {
        case ThemeType.Dark:
            return `mectrl_theme_dark${headerClass}`;
        case ThemeType.AzureHighContrastLight:
            return `mectrl_theme_azure_hclight${headerClass}`;
        case ThemeType.AzureHighContrastDark:
            return `mectrl_theme_azure_hcdark${headerClass}`;
        case ThemeType.Gray:
            return `mectrl_theme_gray${headerClass}`;
        case ThemeType.OffBlack:
            return `mectrl_theme_off_black${headerClass}`;
        case ThemeType.Light:
            return `${isHeader ? `mectrl_theme_light_header` : ``}`;
    }

    assertNever(theme.type, `getThemeClass: Unknown theme type ${theme.type}.`);
}
