import { AnyFunction } from '@mecontrol/common';

export function isString(obj: any): obj is string {
    return typeof obj === "string";
}

export function isNonEmptyString(obj: any): obj is string {
    return !!obj && typeof obj === "string" && obj.trim() !== "";
}

export function isStringOrFunction(obj: any): obj is (string | AnyFunction) {
    return typeof obj === "string" || typeof obj === "function";
}

export function isFunction(obj: any): obj is AnyFunction {
    return typeof obj === "function";
}

export function isElement(node?: any): node is Element {
    return !!node && node.nodeType === Node.ELEMENT_NODE;
}
