import {
    IContentUpdateEvent, IContentUpdateParams,
    IContentUpdatePartB, IContentUpdatePartC
} from '@mecontrol/common';
import { ME, EventMoment, createPartA, getPageTags, getContentJson } from '@mecontrol/web-inline';

const eventName = 'Ms.Webi.ContentUpdate';
const eventBaseType = 'Ms.Content.ContentUpdate';

/**
 * Creates a ContentUpdate telemetry event, capturing the time it took for some part of
 * the MeControl to update
 * @param updateParams Content update parameters
 * @param updateParams.content Information on the content that was updated
 * @param moment Object with information on when the event took place
 * @returns The created ContentUpdate event
 */
export function createContentUpdate(updateParams: IContentUpdateParams, moment: EventMoment): IContentUpdateEvent {
    let partA = createPartA(eventName, moment.date, moment.cv);

    let contentBlob = getContentJson(updateParams.content);

    let partB: IContentUpdatePartB = {
        ver: '1.0',
        impressionGuid: moment.impressionGuid,
        market: ME.Config.mkt,
        pageTags: JSON.stringify(getPageTags(moment.accounts.counts, moment.accounts.current)),
        contentVer: '2.0',
        content: '[' + contentBlob + ']'
    };

    let partC: IContentUpdatePartC = {
        baseType: eventBaseType,
        pageLoadTime: Math.round(updateParams.loadTime),
        timings: JSON.stringify(updateParams.timings),
        cookieEnabled: navigator.cookieEnabled === true,
        isJs: true,
        isLoggedIn: !!moment.accounts.current,
        isManual: true
    };

    return {
        partA,
        partB,
        partC
    };
}

