import { IPageActionEvent, IPageActionParams, IPageActionPartB, IPageActionPartC } from '@mecontrol/common';
import { ME, EventMoment, createPartA, getPageTags, getTimeSince, scrubUrl, getContentJson } from '@mecontrol/web-inline';

const eventName = 'Ms.Webi.PageAction';
const eventBaseType = 'Ms.Content.PageAction';

/**
 * Creates a PageAction event to capture clicks
 * @param eventParams An object with all the information needed to create a PageActionEvent
 * @param eventParams.content Information on the content that was clicked
 * @param eventParams.targetUrl Optional target that a link takes the user to (for clicked links)
 * @param eventParams.behavior Optional description of what the page action will do, as defined in IBehaviors
 * @param eventParams.action Optional description of the page action itself, as defined in IActions
 * @returns The created PageAction event
 */
export function createPageAction(actionParams: IPageActionParams, moment: EventMoment): IPageActionEvent {
    let partA = createPartA(eventName, moment.date, moment.cv);

    let contentBlob = getContentJson(actionParams.content);
    let targetUrl = actionParams.targetUrl && scrubUrl(actionParams.targetUrl);

    let partB: IPageActionPartB = {
        ver: '1.1',
        pageName: moment.pageName,
        impressionGuid: moment.impressionGuid,
        destUri: targetUrl,
        market: ME.Config.mkt,
        pageTags: JSON.stringify(getPageTags(moment.accounts.counts, moment.accounts.current)),
        contentVer: '2.0',
        content: '[' + contentBlob + ']'
    };

    let partC: IPageActionPartC = {
        baseType: eventBaseType,
        timeToAction: getTimeSince(moment.timestamp),
        cookieEnabled: navigator.cookieEnabled === true,
        isJs: true,
        isLoggedIn: !!moment.accounts.current,
        isManual: true
    };

    return {
        partA,
        partB,
        partC
    };
}
