/**
 * @file update-1ds.js
 * Update 1ds telemetry elements after <dynamic-price> pulls in the price data
 * 
 * @eventhandler DYNAMIC-PRICE-UPDATED
 * Event name is set in dynamic-price web component
 * 
 * Depends on the heading of the AEM component to have the class "component-heading"
 */

$(function() {
    $(document).on("DYNAMIC-PRICE-UPDATED", function(e) {
        if (!e.detail ? .priceText) return;
        const $cta = $(e.target.closest('.link-group>*'));
        const priceText = $cta.get(0) ? .textContent ? .replaceAll(/(\s)+/g, ' ');
        if (!$cta.length || !priceText) return;
        ['data-bi-cn', 'data-bi-ecn'].forEach(tag => {
            if ($cta.data('originalText') ? .includes('dynamic-price'))
                $cta.attr(tag, priceText);
        });

        setTimeout(() => {
            const heading = $cta.closest('[data-componentname]').find('.component-heading').get(0) ? .textContent ? .replaceAll(/(\s)+/g, ' ');
            ['data-bi-hn', 'data-bi-ehn'].forEach(tag => {
                if ($cta.attr(tag) ? .includes('dynamic-price'))
                    $cta.attr(tag, heading);
            });
        }, 1000);
    });
});